

// anchor
jQuery(function($){
	$('a[href^="#"]').click(function(){
		var target = $(this).attr('href');
		$('html, body').animate({scrollTop: $(target).offset().top}, 1000);
		return false;
	});
});
// end anchor

// fades
$(function(){
	/*-------------------animation----------------------*/
	$("#fades p").hide();
	function fades($div, cb) {
		$div.fadeIn(2000, function () {
			$div.fadeOut(2000, function () {
				var $next = $div.next();
				if ($next.length > 0) {
					fades($next, cb);
				}
				else {
					// The last element has faded away, call the callback
					cb();
				}
			});
		});
	}

	function startFading($firstDiv) {
		fades($firstDiv, function () {
			startFading($firstDiv);
		});
	}

	startFading($("#fades p:first-child"));
});
/*-------------------animation----------------------*/
// end fades

// clock
jQuery(function($){
	var spd = 100;
	var spdVal = 10;
	var cntDown = 10 * 60 * spdVal;
	setInterval(function () {
		var mn, sc, ms;
		cntDown--;
		if(cntDown < 0) {
			return false;
		}
		mn = Math.floor((cntDown / spdVal) / 60 );
		mn = (mn < 10 ? '0' + mn : mn);
		sc = Math.floor((cntDown / spdVal) % 60);
		sc = (sc < 10 ? '0' + sc : sc);
		ms = Math.floor(cntDown % spdVal);
		ms = (ms < 10 ? '0' + ms : ms);
		var result = mn + ':' + sc;
		if (document.getElementById('time')) {
			document.getElementById('time').innerHTML = result;
		}
	}, spd);
});
// end clock

// popup
jQuery(function($){
	var OpenPopupLink = $('a.open-popup-link');
	var ClosePopupLink = $('a.close-popup-link');
	var PopupWrapper = $('.popup-wrapper');
	OpenPopupLink.click(function() {
		var clickId = this.id;
		$('#popup-' + clickId).fadeIn(300);
		PopupWrapper.fadeIn(300);
		$('body').css('overflow','hidden').css('height','100%');
	});
	ClosePopupLink.click(function() {
		$(this).parents('.popup').fadeOut(300);
		PopupWrapper.fadeOut(300);
		$('body').css('overflow','auto').css('height','auto');
	});
	$(document).keydown(function(eventObject) {
		if ($('[id^="popup-"]').is(":visible")){
			if (eventObject.which == '27') {
				$('[id^="popup-"]').fadeOut(300);
				PopupWrapper.fadeOut(300);
				$('body').css('overflow','auto').css('height','auto');
			}
		}
	});

});
// end popup

//date
jQuery(function($){
    var mydate = new Date();
    var montharray = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
    $('.date-container').text(" " + montharray[mydate.getMonth()] + " "
        + mydate.getDate() + ", " + mydate.getFullYear() );
});
//date end