<?php
//Classes
class sticky{

    public static function init_upsell_purchase($fields,$config)
    {
        /** Possible Request Fields for New Order with CardOnFile Call
            * --form 'previousOrderId=""' \
            * --form 'CVV=""' \
            * --form 'AFID=""' \
            * --form 'SID=""' \
            * --form 'AFFID=""' \
            * --form 'C1=""' \
            * --form 'C2=""' \
            * --form 'C3=""' \
            * --form 'AID=""' \
            * --form 'OPT=""' \
            * --form 'click_id=""' \
            * --form 'productId=""' \
            * --form 'campaignId=""' \
            * --form 'shippingId=""' \
            * --form 'upsellCount=""' \
            * --form 'upsellProductIds=""' \
            * --form 'dynamic_product_price_1=""' \
            * --form 'notes=""' \
            * --form 'product_qty_1=""' \
            * --form 'forceGatewayId=""' \
            * --form 'preserve_force_gateway=""' \
            * --form 'createdBy=""' \
            * --form 'secretSSN=""' \
            * --form 'force_subscription_cycle=""' \
            * --form 'recurring_days=""' \
            * --form 'subscription_week=""' \
            * --form 'subscription_day=""' \
            * --form 'product_attribute_array=""' \
            * --form 'master_order_id=""' \
            * --form 'promoCode=""' \
            * --form 'temp_customer_id=""' \
            * --form 'sessionId=""' \
            * --form 'cascade_override=""' \
            * --form 'utm_source=""' \
            * --form 'utm_medium=""' \
            * --form 'utm_campaign=""' \
            * --form 'utm_term=""' \
            * --form 'utm_content=""' \
            * --form 'device_category=""' \
            * --form 'referrer_id=""' \
            * --form 'product_step[1]=""' \
            * --form 'consent_required=""'
         */
        $body=[
            'tranType'=>'Sale',
            'previousOrderId'=>$fields['orderId'],
            'CVV'=>$fields['CVV'],
            'ipAddress'=>$fields['ipAddress'],
            'campaignId'=>$fields['campaignId'],
            'shippingId'=>$fields['shippingId'],
            'forceGatewayId'=> $fields['gatewayId'],
            'preserve_force_gateway'=> 1,
            'website'=>$config->website,
        ];

        //add product
        $body['offers']=$fields['offers'];

        $output = self::LL_curl_init($body,$config,"/api/v1/new_upsell");
        if(empty($output['responseCode']) && isset($output['response_code'])) $output['responseCode'] = $output['response_code'];
        if(empty($output['errorMessage']) && isset($output['error_message'])) $output['errorMessage'] = $output['error_message'];
        if(empty($output['declineReason']) && isset($output['decline_reason'])) $output['declineReason'] = $output['decline_reason'];
        if(empty($output['orderId']) && isset($output['order_id'])) $output['orderId'] = $output['order_id'];
        
        return $output;

    }

    public static function init_main_purchase($fields,$config)
    {
        /** Possible Request Fields for New Order with Prospect Call
            * --form 'tranType="Sale"' \
            * --form 'firstName=""' \
            * --form 'lastName=""' \
            * --form 'shippingAddress1=""' \
            * --form 'shippingAddress2=""' \
            * --form 'shippingCity=""' \
            * --form 'shippingState=""' \
            * --form 'shippingZip=""' \
            * --form 'shippingCountry=""' \
            * --form 'billingFirstName=""' \
            * --form 'billingLastName=""' \
            * --form 'billingAddress1=""' \
            * --form 'billingAddress2=""' \
            * --form 'billingCity=""' \
            * --form 'billingState=""' \
            * --form 'billingZip=""' \
            * --form 'billingCountry=""' \
            * --form 'phone=""' \
            * --form 'email=""' \
            * --form 'creditCardType=""' \
            * --form 'creditCardNumber=""' \
            * --form 'expirationDate=""' \
            * --form 'CVV=""' \
            * --form 'checkAccountNumber=""' \
            * --form 'checkRoutingNumber=""' \
            * --form 'sepa_iban=""' \
            * --form 'sepa_bic=""' \
            * --form 'eurodebit_acct_num=""' \
            * --form 'eurodebit_route_num=""' \
            * --form 'ipAddress=""' \
            * --form 'AFID=""' \
            * --form 'SID=""' \
            * --form 'AFFID=""' \
            * --form 'C1=""' \
            * --form 'C2=""' \
            * --form 'C3=""' \
            * --form 'AID=""' \
            * --form 'OPT=""' \
            * --form 'click_id=""' \
            * --form 'productId=""' \
            * --form 'campaignId=""' \
            * --form 'shippingId=""' \
            * --form 'upsellCount=""' \
            * --form 'upsellProductIds=""' \
            * --form 'dynamic_product_price_1=""' \
            * --form 'prospectId=""' \
            * --form 'billingSameAsShipping=""' \
            * --form 'notes=""' \
            * --form 'product_qty_1=""' \
            * --form 'forceGatewayId=""' \
            * --form 'preserve_force_gateway=""' \
            * --form 'createdBy=""' \
            * --form 'thm_session_id=""' \
            * --form 'total_installments=""' \
            * --form 'alt_pay_token=""' \
            * --form 'alt_pay_payer_id=""' \
            * --form 'secretSSN=""' \
            * --form 'force_subscription_cycle=""' \
            * --form 'recurring_days=""' \
            * --form 'subscription_week=""' \
            * --form 'subscription_day=""' \
            * --form 'product_attribute_array=""' \
            * --form 'master_order_id=""' \
            * --form 'promoCode=""' \
            * --form 'temp_customer_id=""' \
            * --form 'three_d_redirect_url=""' \
            * --form 'alt_pay_return_url=""' \
            * --form 'sessionId=""' \
            * --form 'ssn_nmi=""' \
            * --form 'utm_source=""' \
            * --form 'utm_medium=""' \
            * --form 'utm_campaign=""' \
            * --form 'utm_term=""' \
            * --form 'utm_content=""' \
            * --form 'device_category=""' \
            * --form 'conversion_id=""' \
            * --form 'referrer_id=""' \
            * --form 'product_step[1]=""' \
            * --form 'consent_required=""'
         */
        $body=[
            'tranType'=>'Sale',
            'prospectId'=>$fields['prospectId'],
            'creditCardType'=>$fields['creditCardType'],
            'creditCardNumber'=>$fields['creditCardNumber'],
            'expirationDate'=>$fields['cc_expires'],
            'CVV'=>$fields['CVV'],
            'ipAddress'=>$fields['ipAddress'],
            'campaignId'=>$fields['campaignId'],
            'shippingId'=>$fields['shippingId'],
            'website'=>$config->website
        ];

        //add product
        $body['offers']=$fields['offers'];

        if(!empty($fields['shippingAddress1'])){
            $body['shippingAddress1']=$fields['shippingAddress1'];
            $body['shippingCity']=$fields['shippingCity'];
            $body['shippingState']=$fields['shippingState'];
            $body['shippingZip']=$fields['shippingZip'];
            $body['shippingCountry']=$fields['shippingCountry'];
        }

        if($fields['billingSameAsShipping']=='no'){
            $body['billingSameAsShipping']='NO';
            $body['billingFirstName']=$fields['billingFirstName'];
            $body['billingLastName']=$fields['billingLastName'];
            $body['billingAddress1']=$fields['billingAddress1'];
            $body['billingCity']=$fields['billingCity'];
            $body['billingState']=$fields['billingState'];
            $body['billingZip']=$fields['billingZip'];
            $body['billingCountry']=$fields['billingCountry'];
        }else{
            $body['billingSameAsShipping']='YES';
        }

        $output = self::LL_curl_init($body,$config,"/api/v1/new_order_with_prospect");
        if(empty($output['responseCode']) && isset($output['response_code'])) $output['responseCode'] = $output['response_code'];
        if(empty($output['errorMessage']) && isset($output['error_message'])) $output['errorMessage'] = $output['error_message'];
        if(empty($output['declineReason']) && isset($output['decline_reason'])) $output['declineReason'] = $output['decline_reason'];
        if(empty($output['orderId']) && isset($output['order_id'])) $output['orderId'] = $output['order_id'];


        return $output;
    }

    public static function init_prospect($fields,$config)
    {
        /** Possible Request Fields for New Prospect Call
            * --form 'campaignId=""' 
            * --form 'email=""' \ 
            * --form 'ipAddress=""' \
            * --form 'firstName=""' \
            * --form 'lastName=""' \
            * --form 'address1=""' \
            * --form 'address2=""' \
            * --form 'city=""' \
            * --form 'state=""' \
            * --form 'zip=""' \
            * --form 'country=""' \
            * --form 'phone=""' \
            * --form 'AFID=""' \
            * --form 'SID=""' \
            * --form 'AFFID=""' \
            * --form 'C1=""' \
            * --form 'C2=""' \
            * --form 'C3=""' \
            * --form 'AID=""' \
            * --form 'OPT=""' \
            * --form 'click_id=""' \
            * --form 'notes=""'
        */
        $body=[
            'firstName'=>$fields['firstName'],
            'lastName'=>$fields['lastName'],
            'address1'=>$fields['shippingAddress1'],
            'city'=>$fields['shippingCity'],
            'state'=>$fields['shippingState'],
            'zip'=>$fields['shippingZip'],
            'country'=>$fields['shippingCountry'],
            'phone'=>$fields['phone'],
            'email'=>$fields['email'],
            'ipAddress'=>$fields['ipAddress'],
            'campaignId'=>$fields['campaignId'],
            'AFID'=>(empty($fields['AFID'])?'':$fields['AFID']),
            'AFFID'=>(empty($fields['AFFID'])?'':$fields['AFFID']),
            'SID'=>(empty($fields['SID'])?'':$fields['SID']),
            'C1'=>(empty($fields['C1'])?'':$fields['C1']),
            'C2'=>(empty($fields['C2'])?'':$fields['C2']),
            'C3'=>(empty($fields['C3'])?'':$fields['C3']),
            'AID'=>(empty($fields['AID'])?'':$fields['AID']),
            'OPT'=>(empty($fields['OPT'])?'':$fields['OPT']),
            'click_id'=>(empty($fields['click_id'])?'':$fields['click_id']),
            'website'=>$config->website,
            'notes'=>(empty($fields['notes'])?'':$fields['notes']),
        ];
        
        $output = self::LL_curl_init($body,$config,"/api/v1/new_prospect");
        if(empty($output['responseCode']) && isset($output['response_code'])) $output['responseCode'] = $output['response_code'];
        if(empty($output['errorMessage']) && isset($output['error_message'])) $output['errorMessage'] = $output['error_message'];
        if(empty($output['declineReason']) && isset($output['decline_reason'])) $output['declineReason'] = $output['decline_reason'];
        
        return $output;
    }

    private static function LL_curl_init($body,$config,$endpoint){
        $body = json_encode($body);
        // Get cURL resource
        $ch = curl_init();
        // Set url
        curl_setopt($ch, CURLOPT_URL, "{$config->crm->domain}{$endpoint}");
        // Set options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'content-type: application/json'
        ));
        curl_setopt($ch, CURLOPT_USERPWD, $config->crm->username.":".$config->crm->password);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        // Set body
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        // Send the request & save response to $resp
        $resp = curl_exec($ch);
        if(!$resp) {
            throw new Exception('Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch));
        } else {
            $output = json_decode($resp, true);
            return $output;
        }
        // Close request to clear up some resources
        curl_close($ch);
    }   
}
?>