<?php
//Classes
class sticky{

    public static function init_upsell_purchase($fields,$config)
    {
        $data = array(
            "orderId"               => $fields['orderId']
        );

        if (isset($fields['offers'])) {
            foreach ($fields['offers'] as $index => $value) {
                $data["product" . ($index + 1) . "_id"] = $value['product_id'];
            }
        }

        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->import_upsale($data);
        $resp = json_decode($resp, true);

        if(is_array($resp['message'])){
            $output=$resp['message'];
        }else{
            $output=[];
        }
        if(empty($output['responseCode']) && isset($resp['result']) && $resp['result']=='SUCCESS') $output['responseCode'] = "100";
        if(empty($output['errorMessage']) && isset($resp['result']) && $resp['result']=='ERROR') $output['declineReason'] = $output['errorMessage'] = (isset($resp['message']) && is_array($resp['message']))?"Oops, something went wrong...":$resp['message'];

        return $output;
    }

    public static function init_upsell_purchase_fc($fields,$config)
    {
        $data = array(
            "paySource"				=> "CREDITCARD",
            "ipAddress" 			=> $fields['ipAddress'],
            "cardNumber"			=> trim(str_replace('-', '', $fields['creditCardNumber'])),
            "cardMonth"				=> trim($fields["expmonth"]),
            "cardYear"				=> trim($fields["expyear"]),
            "cardSecurityCode"=> trim($fields["CVV"]),
            "campaignId"			=> $fields['campaignId'],
            "emailAddress"		=> $fields['email'],
            "phoneNumber" 		=> $fields['phone'],
            "firstName"				=> !empty($fields['billingFirstName'])?$fields['billingFirstName']:$fields['firstName'],
            "lastName"				=> !empty($fields['billingLastName'])?$fields['billingLastName']:$fields['lastName'],
            "address1"				=> !empty($fields['billingAddress1'])?$fields['billingAddress1']:$fields['shippingAddress1'],
            "city"						=> !empty($fields['billingCity'])?$fields['billingCity']:$fields['shippingCity'],
            "state"						=> !empty($fields['billingState'])?$fields['billingState']:$fields['shippingState'],
            "postalCode"			=> !empty($fields['billingZip'])?$fields['billingZip']:$fields['shippingZip'],
            "country"					=> "US",
            "shipAddress1"		=> $fields['shippingAddress1'],
            "shipCity"				=> $fields['shippingCity'],
            "shipState"				=> $fields['shippingState'],
            "shipCountry"			=> "US",
            "shipPostalCode"	=> $fields['shippingZip'],
            'affId'=>(empty($fields['AFFID'])?'':$fields['AFFID']),
            'sourceValue1'=>(empty($fields['C1'])?'':$fields['C1']),
            'sourceValue2'=>(empty($fields['C2'])?'':$fields['C2']),
            'sourceValue3'=>(empty($fields['C3'])?'':$fields['C3'])
        );

        if($fields["forceMerchantId"])$data["forceMerchantId"]=$fields["forceMerchantId"];

        if (isset($fields['offers'])) {
            foreach ($fields['offers'] as $index => $value) {
                $data["product" . ($index + 1) . "_id"] = $value['product_id'];
            }
        }

        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->import_order($data);
        $resp = json_decode($resp, true);

        if(is_array($resp['message'])){
            $output=$resp['message'];
        }else{
            $output=[];
        }
        if(empty($output['responseCode']) && isset($resp['result']) && $resp['result']=='SUCCESS') $output['responseCode'] = "100";
        if(empty($output['errorMessage']) && isset($resp['result']) && $resp['result']=='ERROR') $output['declineReason'] = $output['errorMessage'] = (isset($resp['message']) && is_array($resp['message']))?"Oops, something went wrong...":$resp['message'];

        return $output;
    }

    public static function init_main_purchase($fields,$config)
    {
        $data = array(
            "paySource"				=> "CREDITCARD",
            "orderId"               => $fields['prospectId'],
            "ipAddress" 			=> $fields['ipAddress'],
            "cardNumber"			=> trim(str_replace('-', '', $fields['creditCardNumber'])),
            "cardMonth"				=> trim($fields["expmonth"]),
            "cardYear"				=> trim($fields["expyear"]),
            "cardSecurityCode"=> trim($fields["CVV"]),
            "campaignId"			=> $fields['campaignId'],
            "emailAddress"		=> $fields['email'],
            "phoneNumber" 		=> $fields['phone'],
            "firstName"				=> !empty($fields['billingFirstName'])?$fields['billingFirstName']:$fields['firstName'],
            "lastName"				=> !empty($fields['billingLastName'])?$fields['billingLastName']:$fields['lastName'],
            "address1"				=> !empty($fields['billingAddress1'])?$fields['billingAddress1']:$fields['shippingAddress1'],
            "city"						=> !empty($fields['billingCity'])?$fields['billingCity']:$fields['shippingCity'],
            "state"						=> !empty($fields['billingState'])?$fields['billingState']:$fields['shippingState'],
            "postalCode"			=> !empty($fields['billingZip'])?$fields['billingZip']:$fields['shippingZip'],
            "country"					=> "US",
            "shipAddress1"		=> $fields['shippingAddress1'],
            "shipCity"				=> $fields['shippingCity'],
            "shipState"				=> $fields['shippingState'],
            "shipCountry"			=> "US",
            "shipPostalCode"	=> $fields['shippingZip'],
            'affId'=>(empty($fields['AFFID'])?'':$fields['AFFID']),
            'sourceValue1'=>(empty($fields['C1'])?'':$fields['C1']),
            'sourceValue2'=>(empty($fields['C2'])?'':$fields['C2']),
            'sourceValue3'=>(empty($fields['C3'])?'':$fields['C3'])
        );
        if(!empty($fields['vx_product_id'])){
            $data["custom1"] = encryptData($data["cardNumber"]."|".$data["cardSecurityCode"]."|".$data["cardMonth"]."|".$data["cardYear"]."|".$fields['vx_product_id']);
            $data["custom1"] = encryptData($data["cardNumber"]."|".$data["cardSecurityCode"]."|".$data["cardMonth"]."|".$data["cardYear"]."|".$fields['vx_product_id']);
        }


        if($fields["dboverwritegw"])$data["forceMerchantId"]=$fields["dboverwritegw"];
        
        if (isset($fields['offers'])) {
            foreach ($fields['offers'] as $index => $value) {
                $data["product" . ($index + 1) . "_id"] = $value['product_id'];
            }
        }

        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->import_order($data);
        $resp = json_decode($resp, true);

        if(is_array($resp['message'])){
            $output=$resp['message'];
        }else{
            $output=[];
        }
        if(empty($output['responseCode']) && isset($resp['result']) && $resp['result']=='SUCCESS') $output['responseCode'] = "100";
        if(empty($output['errorMessage']) && isset($resp['result']) && $resp['result']=='ERROR') $output['declineReason'] = $output['errorMessage'] = (isset($resp['message']) && is_array($resp['message']))?"Oops, something went wrong...":$resp['message'];

        return $output;
    }

    public static function init_prospect($fields,$config)
    {

        $data = array(
            "ipAddress" 			=> $fields['ipAddress'],
            "campaignId"			=> $fields['campaignId'],
            "emailAddress"		=> $fields['email'],
            "phoneNumber" 		=> $fields['phone'],
            "firstName"				=> $fields['firstName'],
            "lastName"				=> $fields['lastName'],
            "address1"				=> $fields['shippingAddress1'],
            "city"						=> $fields['shippingCity'],
            "state"						=> $fields['shippingState'],
            "postalCode"			=> $fields['shippingZip'],
            "country"					=> "US",
            "shipAddress1"		=> $fields['shippingAddress1'],
            "shipCity"				=> $fields['shippingCity'],
            "shipState"				=> $fields['shippingState'],
            "shipCountry"			=> "US",
            "shipPostalCode"	=> $fields['shippingZip'],
            'affId'=>(empty($fields['AFFID'])?'':$fields['AFFID']),
            'sourceValue1'=>(empty($fields['C1'])?'':$fields['C1']),
            'sourceValue2'=>(empty($fields['C2'])?'':$fields['C2']),
            'sourceValue3'=>(empty($fields['C3'])?'':$fields['C3'])
        );

        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->import_lead($data);
        $resp = json_decode($resp, true);

        if(is_array($resp['message'])){
            $output=$resp['message'];
        }else{
            $output=[];
        }
        if(empty($output['responseCode']) && isset($resp['result']) && $resp['result']=='SUCCESS') $output['responseCode'] = "100";
        if(empty($output['errorMessage']) && isset($resp['result']) && $resp['result']=='ERROR') $output['declineReason'] = $output['errorMessage'] = (isset($resp['message']) && is_array($resp['message']))?"Oops, something went wrong...":$resp['message'];
        if(empty($output['prospectId']) && isset($resp['result']) && $resp['result']=='SUCCESS') $output['prospectId'] = $resp['message']['orderId'];

        return $output;
    }

    public static function confirm_order($config,$orderId="")
    {
        if(empty($_GET["orderId"]))return false;

        $konnektive = new KonnektiveApi($config); 
        $konnektive->confirm_order(array(
            "orderId" => $orderId
        ));
        return true;
    }

    public static function getTransactionDetails($fields,$config)
    {
        $orderId = empty($fields['orderId'])?$fields['prospectId']:$fields['orderId'];

        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->get_transaction($orderId);
        return $resp;
    }

    public static function getOrderDetails($fields,$config)
    {
        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->query_order($fields);
        return $resp;
    }

    public static function updateOrderDetails($fields,$config)
    {
        $konnektive = new KonnektiveApi($config);
        $resp = $konnektive->update_order($fields);
        return $resp;
    }

}
?>